#include <p30fxxxx.h>
#include <timer.h>

/* These devices support Timer 4 */
#if defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || defined(__dsPIC30F3011__)  || \
    defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__) || \
    defined(__dsPIC30F5015__)

/********************************************************************
*    Function Name:  CloseTimer4                                    *
*    Description:    This routine disables the Timer4 and its       *
*                    interrupt and flag bits.                       *
*    Parameters:     None                                           *
*    Return Value:   None                                           *
********************************************************************/

void CloseTimer4(void)
{
    IEC1bits.T4IE = 0;  /* Disable the Timer4 interrupt */
    T4CONbits.TON=0;    /* disable Timer4 */
    IFS1bits.T4IF = 0;  /* Clear Timer4 interrupt flag */
}

#endif 
